module net.BurtonRadons.spyl.expressionSlice;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.expressionUnary;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.valueNull;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** Slice an array; "a [min .. max]". */
class SliceExpression : UnaryExpression
{
    Expression min; /**< Minimum bound or Null for none. */
    Expression max; /**< Maximum bound or Null for none. */
    
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression min, Expression max)
    {
        super (mark, a);
        this.min = min;
        this.max = max;
    }
    
    override Value evaluate (Scope scope)
    {
        return a.evaluate (scope).getslice (min.evaluate (scope), max.evaluate (scope));
    }
    
    override char [] toString ()
    {
        char [] text;
        
        text = subString (a) ~ " [";
        if (!(ValueExpression) min || !(NullValue) ((ValueExpression) min).value)
            text ~= min.toString ();
        text ~= " .. ";
        if (!(ValueExpression) max || !(NullValue) ((ValueExpression) max).value)
            text ~= max.toString ();
        return text ~ "]";
    }
    
    override int precedence ()
    {
        return Precedence.Postfix;
    }
    
}